///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _Command_CPP
#define _Command_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SqlExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/LZARICode.H"
#include "../../SharedSource/RLECompression.H"
#include "../../SharedSource/ZLibCompression.H"

#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/CMemPool/CMemPool.H"
#include "../../SharedClasses/LZSS/LZSS_Compress.H"
#include "../../SharedClasses/LZSS/LZSS_Uncompress.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"
#include "../../SharedSource/CRC32.H"

#include "Init.H"
#include "Routines.H"
#include "Command.H"
#include "SQLImport.H"
#include "Console.H"
#include "NewDB.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ReceiveFileData(CSockSrvr *pSockSrvr, int iClient, char *sFileName);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int ProcessCommand(CSockSrvr *pSockSrvr, int iClient, char *sRecvBuf, int iRecvBufSz);

	Processes a command from the peer.

	Possible return Values:
		CMD_OK    The command was a success, all is well.
		CMD_DONE  The command was a success, close the connection.
		CMD_ERROR The command failed due to an error.
*/
int ProcessCommand(CSockSrvr *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[SENDBUFSZ + RECVBUFSZ];

	char *sTempPtr = NULL;

	int iSendBufSz = 0;
	int iCmdDataSz = 0;
	int iCmdFlagLength = 0;

/*
	//------------------------------------------------------------------------------------------------
	//After the transfer of the database creation scripts (to create the database
	//	structure skeleton), the client will send the script CRC.
	if((iCmdFlagLength = CmdCmp(sCmdBuf, "::InitializationReadyToResume")))
    {
		WriteLogEx(pSockSrvr->icClientID[iClient], "Client is resuming initialization.", EVENT_NONE);

		pSockSrvr->SetNextSendData(iClient, "::BeginReplication->All");
		return CMD_OK;
	}
*/
	//------------------------------------------------------------------------------------------------
	if((iCmdFlagLength = CmdCmp(sCmdBuf, "::ResumeInit")))
    {
		pSockSrvr->SetNextSendData(iClient, "::BeginReplication->Resume");
		return CMD_OK;
	}
	//------------------------------------------------------------------------------------------------
	//After the transfer of the database creation scripts (to create the database
	//	structure skeleton), the client will send the script CRC.
	if((iCmdFlagLength = CmdCmp(sCmdBuf, "::DBCreationCRC->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		//Check the CRC.
		if(CCI[iClient].dwFileCRC != atol(sCmdData))
		{
			sTempPtr = "Received a corrupt DB creation script.";

			sprintf_s(sCmdData, sizeof(sCmdData), "%s \"%s\". [%X-%X]", sTempPtr,
				CCI[iClient].sFileName, CCI[iClient].dwFileCRC, atol(sCmdData));
			WriteLogEx(pSockSrvr->icClientID[iClient], sCmdData, EVENT_ERROR);

			sprintf_s(sCmdData, sizeof(sCmdData), "::Msg->%s", sTempPtr);
			pSockSrvr->SetNextSendData(iClient, sCmdData);

			DeleteFile(CCI[iClient].sFileName);

			return CMD_ERROR;
		}

		//Create the client database structure skeleton.
		bool bResult = CreateNewDBFromDBCreationScript(&CCI[iClient].cCustSQL,
			pSockSrvr, iClient, CCI[iClient].sFileName);

		DeleteFile(CCI[iClient].sFileName);

		if(bResult)
		{
			//CCI[iClient].cIndexSQL.ExecuteNonQuery(sCmdData); //FIXME: What is this?

			pSockSrvr->SetNextSendData(iClient, "::BeginReplication->All");
			return CMD_OK;
		}
        else{
			sTempPtr = "Failed to create the replication target database.";
			WriteLogEx(pSockSrvr->icClientID[iClient], sTempPtr, EVENT_ERROR);

			sprintf_s(sCmdData, sizeof(sCmdData), "::Msg->%s", sTempPtr);
			pSockSrvr->SetNextSendData(iClient, sCmdData);
			return CMD_ERROR;
        }

		return CMD_OK;
	}
	//------------------------------------------------------------------------------------------------
	//The client is ready to send the client database creation scripts.
	//	This is in response to a "::BeginInit" command.
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SendingDBCreationSQL")))
    {
		GetTempFileName(gsImportTempDir, "WPD", 0, CCI[iClient].sFileName);

		if(ReceiveFileData(pSockSrvr, iClient, CCI[iClient].sFileName))
		{
			if(gbDebugMode)
			{
				sprintf_s(sCmdData, sizeof(sCmdData),
					"Waiting on DB Creation SQL file CRC \"%s\"", CCI[iClient].sFileName);
				WriteLogEx(pSockSrvr->icClientID[iClient], sCmdData, EVENT_NONE);
			}

			return CMD_OK;
		}

		return CMD_ERROR;
	}
	//------------------------------------------------------------------------------------------------
	//The client is reporting that all processing is complete and successful.
	//	This command is sent by the client at the end of a synchronization
	//	(initialized by server commands: "::BeginInit", "::BeginReplication->Transactions"
	//	if the synchronization was fully successful.
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Complete")))
    {
		WriteLogEx(pSockSrvr->icClientID[iClient], "The process has been completed successfully.", EVENT_NONE);

		CCI[iClient].cIndexSQL.bThrowErrors = true;

		if(CCI[iClient].bRequestInit)
		{
			sprintf_s(sCmdData, sizeof(sCmdData),
				"UPDATE [%s].[%s].[Companys]"
				" SET [InitStep] = -1"
				" WHERE [CompName] = '%s'",
				gsSQLIndexDatabase, gsDefaultDBO, CCI[iClient].sCompanyName);

			CCI[iClient].cIndexSQL.ExecuteNonQuery(sCmdData);
		}

		UpdateClientStats(pSockSrvr, iClient, &CCI[iClient].cIndexSQL);

		return CMD_DONE;
	}
	//------------------------------------------------------------------------------------------------
	//This is a general processing message from the client.
	//	All messages are file logged and written to the event log.
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Msg->")))
    {
		if(gbDebugMode)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Received a message from the server.", EVENT_NONE);
		}

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		WriteLogEx(pSockSrvr->icClientID[iClient], sCmdData, EVENT_INFO);
		return CMD_OK;
	}
	//------------------------------------------------------------------------------------------------
	//After the transfer of the transactional data, the client will send the data file CRC.
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::TransDataCRC->")) ||
		(iCmdFlagLength = CmdCmp(sCmdBuf, "::TransDumpCRC->")))
    {
		bool bCheckExistance = true;
		bool bResult = false;

		int iReturn = -1;
		int iID = 0;

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		if(CCI[iClient].dwFileCRC != atol(sCmdData))
		{
			sprintf_s(sCmdData, sizeof(sCmdData),
				"Received a corrupt transaction file \"%s\". [%X-%X]",
				CCI[iClient].sFileName, CCI[iClient].dwFileCRC, atol(sCmdData));
			WriteLogEx(pSockSrvr->icClientID[iClient], sCmdData, EVENT_ERROR);

			if(CCI[iClient].bRequestInit)
			{
				//Rerty transfer of file data while initializing.
				if(gbRTOFDWI)
				{
					if(CCI[iClient].dwCorruptInitRetry >= 5)
					{
						sprintf_s(sCmdData, sizeof(sCmdData),
							"Failed to receive file after %d Unsuccessful retries. Failing!",
							CCI[iClient].dwCorruptInitRetry);
						WriteLogEx(pSockSrvr->icClientID[iClient], sCmdData, EVENT_ERROR);
						
						iReturn = CMD_ERROR;					
					}
					else{
						CCI[iClient].dwCorruptInitRetry++;

						sprintf_s(sCmdData, sizeof(sCmdData),
							"Making request %d for corrupt data file.",
							CCI[iClient].dwCorruptInitRetry);
						WriteLogEx(pSockSrvr->icClientID[iClient], sCmdData, EVENT_WARN);
										
						sprintf_s(sCmdData, sizeof(sCmdData),
							"::TransDataDatabase->%s", CCI[iClient].sTransDatabase);
						pSockSrvr->SetNextSendData(iClient, sCmdData);

						sprintf_s(sCmdData, sizeof(sCmdData), 
							"::TransDataTable->%s", CCI[iClient].sTransTable);
						pSockSrvr->SetNextSendData(iClient, sCmdData);

						sprintf_s(sCmdData, sizeof(sCmdData), 
							"::TransDataDBO->%s", CCI[iClient].sTransDBO);
						pSockSrvr->SetNextSendData(iClient, sCmdData);

						pSockSrvr->SetNextSendData(iClient, "::DumpTable");
	
						iReturn = CMD_OK;
					}
				}
				else{
					pSockSrvr->SetNextSendData(iClient, "::LastImportFailed");
					// FIXME: Should we return CMD_OK or CMD_ERROR?

					iReturn = CMD_ERROR;
				}
			}
			else{
				pSockSrvr->SetNextSendData(iClient, "::LastImportFailed");
				// FIXME: Should we return CMD_OK or CMD_ERROR?
				iReturn = CMD_OK;
			}
		}

		if(iReturn != -1)
		{
			DeleteFile(CCI[iClient].sFileName);
			return iReturn;
		}


		if(CCI[iClient].bRequestInit)
		{
			bCheckExistance = false;
		}

		CCI[iClient].dwCorruptInitRetry = 0;

		bResult = ImportSQLResults(pSockSrvr, iClient, &iID, bCheckExistance, CCI[iClient].sFileName);

		if(!CCI[iClient].cCustSQL.ExecuteNonQuery("USE [Master]"))
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Failed to change Master database context. Performance will be affected.", EVENT_WARN);
		}

		DeleteFile(CCI[iClient].sFileName);

		if(bResult)
        {
			if(CCI[iClient].bRequestInit)
			{
				char sSQL[1024];

				sprintf_s(sSQL, sizeof(sSQL), 
					"UPDATE [%s].[%s].[Companys] SET"
					" [InitStep] = '%d'"
					" WHERE [CompName] = '%s'",
					gsSQLIndexDatabase, gsDefaultDBO, iID, CCI[iClient].sCompanyName);
				CCI[iClient].cIndexSQL.ExecuteNonQuery(sSQL);
			}

			pSockSrvr->SetNextSendData(iClient, "::LastImportSuccess");
			return CMD_OK;
        }
        else{
            // FIXME: Should we return CMD_OK or CMD_ERROR?
			pSockSrvr->SetNextSendData(iClient, "::LastImportFailed");
			return CMD_ERROR;
        }

		return CMD_ERROR;
	}
	//------------------------------------------------------------------------------------------------
	//Receive the Transaction Data File size.
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::TransDataFileSize->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		CCI[iClient].dwTransFileSize = atol(sCmdData);
		return CMD_OK;
	}
	//------------------------------------------------------------------------------------------------
	//Receive the Transaction Data File database.
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::TransDataDatabase->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		strcpy_s(CCI[iClient].sTransDatabase, sizeof(CCI[iClient].sTransDatabase), sCmdData);
		return CMD_OK;
	}
	//------------------------------------------------------------------------------------------------
	//Receive the Transaction Data File table.
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::TransDataTable->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		strcpy_s(CCI[iClient].sTransTable, sizeof(CCI[iClient].sTransTable), sCmdData);
		return CMD_OK;
	}
	//------------------------------------------------------------------------------------------------
	//Receive the Transaction Data File default DBO.
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::TransDataDBO->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		strcpy_s(CCI[iClient].sTransDBO, sizeof(CCI[iClient].sTransDBO), sCmdData);
		return CMD_OK;
	}
	//------------------------------------------------------------------------------------------------
	//The "::SendingTransData" command is send when the client ready
	//	to send the transactional data file. This is either in response
	//	to a "::DumpTable" command or part of the transactional or
	//	full synchronization commands.
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SendingTransData")))
    {
		float fSize = (float) CCI[iClient].dwTransFileSize;
		
		sprintf_s(sCmdData, sizeof(sCmdData), "Receiving transaction data for [%s].[%s].[%s] (%.3f KB)",
			CCI[iClient].sTransDatabase,
			CCI[iClient].sTransDBO,
			CCI[iClient].sTransTable,
			fSize / 1024);
		WriteLogEx(pSockSrvr->icClientID[iClient], sCmdData, EVENT_NONE);

		GetTempFileName(gsImportTempDir, "WPD", 0, CCI[iClient].sFileName);

		if(ReceiveFileData(pSockSrvr, iClient, CCI[iClient].sFileName))
		{
			return CMD_OK;
		}

		return CMD_ERROR;
	}
	//------------------------------------------------------------------------------------------------
/*
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SendingFileData->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		GetTempFileName(gsImportTempDir, "WPD", 0, CCI[iClient].sFileName);

		if(ReceiveFileData(pSockSrvr, iClient, CCI[iClient].sFileName))
		{
			return CMD_OK;
		}

		return CMD_ERROR;
	}
*/
	//------------------------------------------------------------------------------------------------

	WriteLogEx(pSockSrvr->icClientID[iClient], "Received unknown command.", EVENT_ERROR);

	sCmdBuf[1024] = '\0';
	WriteLogEx(pSockSrvr->icClientID[iClient], sCmdBuf, EVENT_ERROR);
	return CMD_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool UpdateClientStats(CSockSrvr *pSockSrvr, int iClient, CSQL *lpSQL)
{
	SYSTEMTIME ST;

	char sSQL[2048];
	char lsDate[64];
	char lsTime[64];

	char sConnectTime[128];
	char sDisconnectTime[128];

	GetDateFormat(NULL, 0, &CCI[iClient].stConnectTime, "MM/dd/yyyy", lsDate, sizeof(lsDate));
	GetTimeFormat(NULL, 0, &CCI[iClient].stConnectTime, "HH:mm:ss", lsTime, sizeof(lsTime));
	sprintf_s(sConnectTime, sizeof(sConnectTime), "%s %s", lsDate, lsTime);

	GetSystemTime(&ST);
	GetDateFormat(NULL, 0, &ST, "MM/dd/yyyy", lsDate, sizeof(lsDate));
	GetTimeFormat(NULL, 0, &ST, "HH:mm:ss", lsTime, sizeof(lsTime));
	sprintf_s(sDisconnectTime, sizeof(sDisconnectTime), "%s %s", lsDate, lsTime);

	sprintf_s(sSQL, sizeof(sSQL),
		"INSERT INTO [%s].[%s].[CompanyStats]"
		" ([Company_Key], [ConnectTime], [DisconnectTime], [BytesSent], [BytesReceived])"
		" SELECT IsNull((SELECT TOP 1 ID FROM [Companys] WHERE [CompName] = '%s'), -1),"
		" '%s', '%s', %d, %d",
		gsSQLIndexDatabase, gsDefaultDBO, CCI[iClient].sCompanyName,
		sConnectTime, sDisconnectTime, CCI[iClient].dwBytesSent, CCI[iClient].dwBytesRecv);

	lpSQL->ExecuteNonQuery(sSQL);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ReceiveFileData(CSockSrvr *pSockSrvr, int iClient, char *sFileName)
{
    FILE *hTargetHandle = NULL;

    char sText[1024];
	char sFullFile[MAX_PATH];
	char sRecvBuf[RECVBUFSZ + 1];
    int iRecvBufSz = 0;

	DWORD dwDataCRC = 0xffffffff;

	if(gbDebugMode)
	{
		WriteLogEx(pSockSrvr->icClientID[iClient], "Begining file transfer.", EVENT_NONE);
	}

	if(_strcmpi(gsCompressionMethod, "None") != 0)
	{
		sprintf_s(sFullFile, sizeof(sFullFile), "%s.sec", sFileName);
	}
	else strcpy_s(sFullFile, sizeof(sFullFile), sFileName);

	if(fopen_s(&hTargetHandle, sFullFile, "wb") != 0)
    {
		WriteLogEx(pSockSrvr->icClientID[iClient], "Failed to open export file for binary write.", EVENT_ERROR);
        return false;
    }

	if(gbDebugMode)
	{
		sprintf_s(sText, sizeof(sText), "File opened successfully. [%s]", sFullFile);
		WriteLogEx(pSockSrvr->icClientID[iClient], sText, EVENT_NONE);
	}

	while(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
    {
		if(pSockSrvr->GetClientData(iClient, sRecvBuf, &iRecvBufSz))
        {
			if(iRecvBufSz == 5)
			{
				sRecvBuf[iRecvBufSz] = '\0';
				if(strcmp(sRecvBuf, "::EOF") == 0)
				{
					break; // All is well.
				}
			}

			CCI[iClient].SC.Cipher(sRecvBuf, iRecvBufSz);
			
            dwDataCRC = PartialCRC(dwDataCRC, sRecvBuf, iRecvBufSz);
			fwrite(sRecvBuf, sizeof(char), iRecvBufSz, hTargetHandle);
		}
		else Sleep(1);
	}

	dwDataCRC = (dwDataCRC ^ 0xffffffff);
	CCI[iClient].dwFileCRC = dwDataCRC;

	sprintf_s(sRecvBuf, sizeof(sRecvBuf), "Data transfer comlete. CRC: %X", dwDataCRC);
	WriteLogEx(pSockSrvr->icClientID[iClient], sRecvBuf, EVENT_NONE);

	fclose(hTargetHandle);

	if(Get_FileSize(sFullFile) <= 0)
	{
		WriteLogEx(pSockSrvr->icClientID[iClient], "Received a zero byte transaction file.", EVENT_ERROR);
		return false;
	}

	if(_strcmpi(gsCompressionMethod, "None") != 0)
	{
		float dwBeforeSz = 0;
		float dwAfterSz = 0;

		sprintf_s(sFullFile, sizeof(sFullFile), "%s.sec", sFileName);

		dwBeforeSz = (float) Get_FileSize(sFullFile);

		sprintf_s(sRecvBuf, sizeof(sFullFile), "Decompressing file. (%.2f KB)", dwBeforeSz / 1024);
		WriteLogEx(pSockSrvr->icClientID[iClient], sRecvBuf, EVENT_NONE);

		if(_strcmpi(gsCompressionMethod, "GZIP") == 0){
			GZip_Inflate_File(sFullFile, sFileName);
		}
		else if(_strcmpi(gsCompressionMethod, "LZSS") == 0){
			LZSSDeCompressFile(sFullFile, sFileName);
		}
		else if(_strcmpi(gsCompressionMethod, "LZARI") == 0){
			DecompressFile(sFullFile, sFileName);
		}
		else if(_strcmpi(gsCompressionMethod, "RLE") == 0){
			RLEDecodeFile(sFullFile, sFileName);			
		}

		dwAfterSz = (float) Get_FileSize(sFileName);

		sprintf_s(sRecvBuf, sizeof(sRecvBuf),
			"File size increased from %.2f KB to %.2f KB. (%.2f %% Decompression).",
			dwBeforeSz / 1024, dwAfterSz / 1024, (100 - ((dwBeforeSz / dwAfterSz) * 100)));
		WriteLogEx(pSockSrvr->icClientID[iClient], sRecvBuf, EVENT_NONE);

		if(gbDeleteCompressedFiles)
		{
			DeleteFile(sFullFile);
		}
	}

	if(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
	{
		return true;
	}

	WriteLogEx(pSockSrvr->icClientID[iClient], "Failed to receive client data. Client disconncted.", EVENT_ERROR);

	return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
